const serverSystem = server.registerSystem(0, 0);

let position = null
let gameTicks = 0

let query = null

let entityId = 'minecraft:creeper'
let height = 10

// Setup which events to listen for
serverSystem.initialize = function () {
  query = this.registerQuery()

  this.listenForEvent('minecraft:player_placed_block', (eventData) => {
    position = eventData.data.block_position
    position.y++
  })
}

// per-tick updates
serverSystem.update = function() {
  gameTicks++

  // summon every second tick
  if (position && gameTicks % 2 === 0) {
    // summon a new entity
    let entity = this.createEntity('entity', entityId)
    this.setPosition(entity, position)

    // update the other entities
    let entities = this.getEntitiesFromQuery(query)
    for (let entity of entities) {
      if (entity.__identifier__ !== entityId) continue

      let entityPosition = this.getComponent(entity, 'minecraft:position')

      if (entityPosition) {
        entityPosition = entityPosition.data

        if (entityPosition.y - position.y > height) {
          this.destroyEntity(entity)
        } else {
          entityPosition.y += 1
          // entityPosition.x = position.x + (Math.floor(Math.random() * (3 - -3 + 1)) + -3)

          this.setPosition(entity, entityPosition)
        }
      }
    }
  }
}

serverSystem.setPosition = function (entity, position) {
  let component = this.createComponent(entity, 'minecraft:position')

  if (component) {
    component.data = position
    this.applyComponentChanges(entity, component)
  }
}

serverSystem.getPosition = function (entity) {
  return this.getComponent(entity, 'minecraft:position')
}

serverSystem.chat = function (message) {
	let event = this.createEventData('minecraft:display_chat_event')
	event.data.message = message
	this.broadcastEvent('minecraft:display_chat_event', event)
}
